///
/*
ressources

tuto débutant A-Z -- https://www.youtube.com/playlist?list=PLPYzvS8A_rTaNDweXe6PX4CXSGq4iEWYC
tuto avancés -- https://www.youtube.com/@synth_def -- https://nathan.ho.name/pages/about/
mes synthdef un peu chelou : https://github.com/Jules-dejardin/supercoollider42k

|| n'hésitez pas à m'envoyer un message si vous avez de petites questions // :) ||
*/
///

// réglages du server

s.options.sampleRate_("48000"); // sample rate, fréquence d'échantillonage

s.options.numInputBusChannels_(1); // nombre d'entrées
s.options.numOutputBusChannels_(12); // nombres de sorties

(
s.options.outDevice_("name of the device"); // spécification du canal d'entrée (micro,..)
s.options.inDevice_("name of the device"); // spécification du canal de sortie (enceinte)
)
///
/*
// shortcuts (Edit > Preferences > Shortcuts)
ctrl + b == boot du serveur (tout devient vert en bas à droite de l'UI)
ctrl + . -> STOPPE LE SON, en vérité kill toutes les instances sur le serveur
ctrl + Enter == evaluation d'un block
maj + enter == evaluation d'une ligne ligne

// help
ctrl + d == doc des UGENS
ctrl + maj + d == recherche dans la doc
ctrl + maj + espace == réafficher la mini pop up avec les arguments d'une fonction
tab == dans une fonction, nomme l'argument selon l'emplacement du curseur
//  debug
ctrl + m == meter level
ctrl + alt + m == analyseur de fréquence
ctrl + maj + m == stethoscope par canal
ctrl + alt + t == node tree
*/

/* *************************************************************** */
/* *********************** EXEMPLE 1 ***************************** */
/* *************************************************************** */
/*
Ce code SuperCollider exécute simultanément deux générateurs de signal sonore, chacun produisant une onde sinusoïdale à une fréquence spécifique.
*/

( // les parenthèses () déclarent un bloc d'instructions, avec ctrl+enter toutes les lignes seront évaluées en même temps
// première onde sinusoidale à la fréquence 220 (un la)
{ // entre accolades {} on définit une fonction
	SinOsc // classe en SuperCollider qui génère une onde sinusoïdale, produisant ainsi un son pur (sans harmoniques).
	.ar
	/*
	signifie que cet oscillateur fonctionne à une vitesse audio, c'est-à-dire à une fréquence suffisamment élevée pour être perçue comme un son. Dans SuperCollider, ar est utilisé pour le traitement audio, tandis que kr (control-rate) est destiné aux signaux de contrôle (plus lents).
	*/
	( // la méthode ar attend des arguments
		220, // une fréquence
		mul:0.7 // un scalaire pour l'amplitude du signal, on skippe les autres arguments (ici la phase) en le nommant: mul: 0.7

	)
}.play; // La méthode .play est appelée sur l'ensemble de la fonction {SinOsc.ar(220, mul: 0.7)}. Elle exécute immédiatement cette fonction dans SuperCollider, démarrant ainsi la production du son.

// deuxième onde sinusoidale à la fréquence 440 (un la à l'octave au dessus car 440=220*2) == la première harmonique
{
	SinOsc.ar(440,mul:0.7)
}.play;
)

/* *************************************************************** */
/* *********************** EXEMPLE 2 ***************************** */
/* *************************************************************** */
/*
Ce code SuperCollider crée une enveloppe d'amplitude, en utilisant la classe Env, et affiche sa forme avec la méthode plot.
*/

/*
Env est une classe en SuperCollider utilisée pour définir des enveloppes d'amplitude. Les enveloppes contrôlent la variation de l'amplitude d'un signal au cours du temps, ce qui est essentiel pour modeler des sons dynamiques. Une enveloppe classique comporte plusieurs segments correspondant à différentes phases de l'évolution de l'amplitude.
*/
(
Env(
	[ // liste de niveaux
		0, // L'enveloppe commence avec une amplitude de 0.
		1, // L'amplitude augmente rapidement jusqu'à 1.
		0  // L'amplitude redescend ensuite à 0.

	],
	[ // liste qui représente la durée de chaque niveau
		0.001, // Durée du premier segment (de 0 à 1). La montée est très rapide.
		0.5    // Durée du deuxième segment (de 1 à 0), définissant le déclin vers zéro.
	],
	-4 // applique une courbe exponentielle descendante, rendant la transition entre les points plus douce et plus naturelle, surtout lors de la descente.
).plot // La méthode .plot génère une visualisation graphique de cette enveloppe, montrant son évolution dans le temps. Cela permet de voir précisément la montée rapide suivie du decay graduel.
)

/* *************************************************************** */
/* *********************** EXEMPLE 3 ***************************** */
/* *************************************************************** */

/* *********************** EXEMPLE 3.1 *************************** */
// on dit au serveur que le synthé existe. définit un synthétiseur nommé \blip avec une série de transformations et de modulations pour générer un son complexe.  Il faudra le jouer dans un second temps
(
// SynthDef crée une définition de synthétiseur nommée \blip. Le bloc de code {...} contient les instructions de création du son.
SynthDef(
	\blip, // on nomme le synthé en mémoire, on peut aussi utiliser la syntaxe 'blip' mais on voit plus souvent la syntaxe avec le backslash: \blip
	{
	// on définit des variables avec des valeurs par défaut qui seront accessibles depuis l extérieur
	arg freq=220, // une hauteur de note
		out=0,    // un canal de sortie
		pan=0;    // paramètre de spatialisation stéréo (panoramique)
	// on déclare des variables accessibles uniquement dans le scope
	// une variable pour le son final (sig) et une variable qui contiendra l'enveloppe
	var sig, env;
		// même enveloppe que dans l'exemple précédent avec l'ajout d'un argument doneAction à 2 qui indique que le synthétiseur doit se terminer une fois l'enveloppe terminée.
	env = EnvGen.kr(Env([0,1,0], [0.01,0.5], -4),doneAction:2); // enveloppe du son, comment le volume va se comporter.

	// création du signal
	sig = (
			Saw.ar // crée une onde en dents de scie
			(
				[ // liste de fréquences, fondamentale et harmoniques
					freq,
					freq*1.25,
					freq*1.5,
					freq*2

				],
				mul:0.2 // ajuste l'amplitude de ces oscillateurs pour éviter la saturation.

			)
			+
			LFPulse.ar( //  ajoute un oscillateur en onde carrée basse fréquence (pulse)
				freq,
				mul:0.15)
		).sum; // somme les différents oscillateurs pour créer un signal riche en harmoniques.
	// filtrage du signal
	sig = RLPF.ar // Un filtre passe-bas résonant appliqué au signal pour en modifier la texture.
		(
			sig, // signal d entrée
			// fréquence de coupure (cutoff)
			LFNoise2.ar(
				1 // génère un bruit basse fréquence, modifiant la fréquence de coupure en continu

		).linlin // mapping, adapte la plage du bruit (de -1 à 1) à celle de 250 Hz à 3000 Hz.
			(
				-1,
				1,
				250,
				3000

		    ),
			//  détermine la résonance du filtre, variant entre 0.05 et 0.3.
			LFNoise2.ar(
				0.2

		).linlin(
				-1,
				1,
				0.05,
				0.3

		), 0.5).tanh; // La fonction tangente hyperbolique applique une légère saturation, adoucissant le signal.
	sig = sig * env; // application de l'enveloppe
	sig = Pan2.ar(sig, pan); // spacialisation
	Out.ar(out, sig); // envoie le signal final vers la sortie spécifiée par out.
}).add;
)

/* *********************** EXEMPLE 3.2 *************************** */
//jouer le synthétiseur, ici en jouant la note la
Synth(\blip,[\freq, 440]);

/* *********************** EXEMPLE 3.3 *************************** */
// pattern
// utilise le pattern Pbind dans SuperCollider pour déclencher le synthétiseur \blip de manière répétitive, avec des variations de fréquence, de panoramique et de durée.
(
// Pbind (Pattern Bind) est un type de pattern en SuperCollider qui associe différents paramètres d’un synthétiseur à des valeurs ou d'autres patterns. Ce pattern déclenche des instances du synthétiseur \blip avec des variations de paramètres à chaque note jouée.
Pbind(
	// La clé \instrument indique quel synthétiseur sera utilisé par ce pattern. Ici, \blip fait référence au SynthDef nommé \blip (défini précédemment).
	\instrument, \blip,
	// La clé \freq contrôle la fréquence de chaque note jouée par le synthétiseur.
	// Pseq est un pattern séquentiel qui répète les valeurs données dans un ordre spécifique.
	\freq, Pseq([440, 440*2, 440*1.5], inf), // L'argument inf (infini) spécifie que ce pattern se répétera indéfiniment, revenant au début une fois la séquence terminée.
	// La clé \pan contrôle la spatialisation du son, en plaçant chaque note dans le champ stéréo.
	\pan, Pseq([-1,1,0],inf), // son complètement à gauche, puis à droite, puis au centre
	// paramètre de durée de chaque note
	//
	\dur, Pseq([1/4,1/4,1/8,1/8,1/8,1/8], inf)
).play; // lecture du pattern. le pattern continuera de jouer en boucle infinie jusqu'à ce qu'il soit explicitement arrêté.
)


[0,1]

